# Dieses Skript genau einmal ausfuehren, wenn die MySQL-Datenbankversion echt kleiner 5.1 ist.
# Ab MySQL 5.1 dieses Skript NICHT ausfuehren.
# Die MySQL-Version kann mit 'SELECT version()' ermittelt werden.

# Das verwendete HenneApp-Tool 'Flyway' untersuetzt MySQL ab Version 5.1.
# Erst ab dieser Version wird das sogenannte INFORMATION_SCHEMA bereitgestellt.
# Damit Flyway mit MySQL - Versionen vor 5.1 funktioniert, muss das INFORMATION_SCHEMA
# mit diesem Skript angelegt werden. Das Skript muss auf der Datenbank einmal ausgefuehrt werden.

# Nach Ausfuehrung des Skripts unterstuetzt HenneApp MySql ab Version 4.1.

# Wird das Skript versehentlich auf MySQL ab Version 5.1 ausgefuehrt oder wird es versehentlich doppelt
# ausgefuehrt, kommt es lediglich zu Fehlermeldungen. Diese knnen ignoriert werden.

CREATE DATABASE IF NOT EXISTS INFORMATION_SCHEMA;
CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.TABLES (TABLE_SCHEMA varchar(50));
CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.SCHEMATA (SCHEMA_NAME varchar(50));
CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.VIEWS (TABLE_SCHEMA varchar(50));
CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.TABLE_CONSTRAINTS (TABLE_SCHEMA varchar(50));
CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.EVENTS (EVENT_SCHEMA varchar(50));
CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.ROUTINES (ROUTINE_SCHEMA varchar(50));

# Mit dem unique key auf SCHEMA_NAME verhindern wir das (versehentliche) doppelte Einfgen des Wertes 'winmilp'.
ALTER TABLE INFORMATION_SCHEMA.SCHEMATA ADD CONSTRAINT unique_schema_name UNIQUE (SCHEMA_NAME);
INSERT IGNORE INTO INFORMATION_SCHEMA.SCHEMATA(SCHEMA_NAME) VALUES ('winmilp');
